define(['angular', 'app', 'TrackersFHIRService'], function (angular, app) {
    'use strict';

    app.service('CholesterolFHIRService', function (TrackersFHIRService) {
        var emptyCholesterolResource = {
            meta: {
                tag: [
                    {
                        'system': 'https://wiki.mobilehealth.DOMAIN.EXT/display/PGDMS/Client+Provenance+Mapping',
                        'code': 'REDACTED',
                        'display': 'VA FitHeart'
                    }
                ],
            },
            code: {
                coding: [{system: 'http://loinc.org', code: '24331-1', display: 'Lipid 1996 panel - Serum or Plasma'}]
            },
            component: [
                {
                    code: {coding: [{system: 'http://loinc.org', code: '9830-1', display: 'Cholesterol.total/Cholesterol in HDL [Mass Ratio] in Serum or Plasma'}]},
                    valueQuantity: {unit: "mg/dl"},
                },
                {
                    code: {coding: [{system: 'http://loinc.org', code: '13457-7', display: 'Cholesterol in LDL [Mass/volume] in Serum or Plasma by calculation'}]},
                    valueQuantity: {unit: "mg/dl"},
                },
                {
                    code: {coding: [{system: 'http://loinc.org', code: '2085-9', display: 'Cholesterol in HDL [Mass/volume] in Serum or Plasma'}]},
                    valueQuantity: {unit: "mg/dl"},
                },
                {
                    code: {coding: [{system: 'http://loinc.org',code: '2571-8', display: 'Triglyceride [Mass/volume] in Serum or Plasma'}]},
                    valueQuantity: {unit: "mg/dl"}  },
                ,
                {   code: {coding: [{system: 'http://loinc.org',code: '49541-6',display: 'Unknown'}]},
                    valueString: 'Unknown'
                }
            ]

        };

        var positions = {
            Fasting: {
                code: {coding: [{system: 'http://loinc.org',code: '49541-6',display: 'Fasting 8 Hours'}]},
                valueString: 'Fasting (8 hours)'},
            AfterMeal: {code: {coding: [{system: 'http://loinc.org',code: '49541-6',display: 'After Meal'}]},
                valueString: 'After Meal'},
            Unknown: {code: {coding: [{system: 'http://loinc.org',code: '49541-6',display: 'Unknown'}]},
                valueString: 'Unknown'
            }
        }

        return angular.extend({}, angular.copy(TrackersFHIRService), {
            code: 'http://loinc.org|24331-1',
            supportsLatest: true,


            buildResource: function (ngModel) {
                TrackersFHIRService.buildResource(ngModel);

                if (ngModel.method) {
                    ngModel.component[4] = positions[ngModel.method];
                    ngModel.method = undefined;
                } else if (ngModel.component[4]) {
                    // remove position if it's been unset
                    ngModel.component = ngModel.component.splice(0, 4);
                    ngModel.method = undefined;
                }

                ngModel.component = ngModel.component.map(function (item) {
                    // convert string numbers back to regular int
                    if (item.hasOwnProperty('valueQuantity')) {
                        item.valueQuantity.value = parseInt(item.valueQuantity.value);
                    }
                    return item;
                });

                return ngModel;
            },

            createEmpty: function () {
                var emptyResource = angular.copy(emptyCholesterolResource);

                return angular.extend({}, TrackersFHIRService.createEmpty(), emptyResource);
            },

            transformItem: function (item, ngModel) {

                TrackersFHIRService.transformItem(item);

                if (item.component[4]) {
                    item.method = item.component[4].valueString;
                }

            }
        });
    });
});